IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Facturado_Cobrado') 
                   AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Facturado_Cobrado 
END
GO

CREATE PROCEDURE CPJ_Facturado_Cobrado @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

DECLARE @pModoDebug			TINYINT,
		@pPeriodo_Desde		DATETIME,
		@pPeriodo_Hasta		DATETIME,
		@pFactura_Desde		DATETIME,
		@pFactura_Hasta		DATETIME,
		@pRecibo_Desde		DATETIME,	
		@pRecibo_Hasta		DATETIME

SET @pModoDebug			    = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')),0)
SET @pPeriodo_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Periodo_Desde')),GETDATE())
SET @pPeriodo_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Periodo_Hasta')),GETDATE())
SET @pFactura_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Factura_Desde')),'19000101')
SET @pFactura_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Factura_Hasta')),'99990101')
SET @pRecibo_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Recibo_Desde')),'19000101')
SET @pRecibo_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Recibo_Hasta')),'99990101')

IF @pModoDebug <> 0
BEGIN
	PRINT @pPeriodo_Desde
	PRINT @pPeriodo_Hasta
	PRINT @pFactura_Desde
	PRINT @pFactura_Hasta
	PRINT @pRecibo_Desde
	PRINT @pRecibo_Hasta
END


SELECT  pf.id_familia    
		,ROUND(SUM(
				(a.importe / f.imp_total)   /*coeficiente aplicado de con respecto a la factura*/
				 * ci.imp_final 
                 * tf.compromete_factura 
				 * f.cotizacion 
				 * (1- (f.Porc_Bonificacion/100))/*bonif factura*/ 
				 ),2)
				 AS cobrado 
INTO #TmpCobrado
FROM cbtes_items ci ,cbtes f , cbtes_tipos tf,productos p,Prod_Familias pf,cbtes_aplica a,cbtes r,cbtes_tipos tr 
WHERE ci.id_trans = f.id_trans 
AND f.id_tipo_cbte = tf.id_tipo_cbte 
AND tf.compromete_factura in (1,-1) 
AND ci.id_producto = p.Id_Producto 
AND p.Id_Familia = pf.Id_Familia 
AND a.Id_Trans_D = r.Id_Trans
AND r.Fecha >= @pRecibo_Desde
AND r.Fecha < @pRecibo_Hasta + 1
AND f.id_trans = a.id_trans
AND r.id_tipo_cbte = tr.id_tipo_cbte
AND tr.compromete_recibos in (1,-1) 
AND r.id_estado_cbte in (1,2,4)  
AND f.id_estado_cbte in (1,2,4)  
AND a.IMPORTE > 0  
AND f.Fecha >= @pFactura_Desde
AND f.Fecha < @pFactura_Hasta
AND r.imp_total <> 0  
AND f.imp_total <> 0 
AND ISNULL(ci.Fecha_QA,f.fecha) >= @pPeriodo_Desde	
AND ISNULL(ci.Fecha_QA,f.fecha) < @pPeriodo_Hasta + 1
GROUP BY pf.id_familia


/*FACURADO*/
SELECT  pf.id_familia,
		ROUND(SUM(ci.imp_final 
				* tf.compromete_factura 
				* f.cotizacion 
				* (1- (f.Porc_Bonificacion/100))  /*bonif factura*/ 
				),2)    AS Facturado
INTO #TmpFacturado
FROM cbtes_items ci ,cbtes f , cbtes_tipos tf,productos p,Prod_Familias pf
WHERE ci.id_trans = f.id_trans 
AND f.id_tipo_cbte = tf.id_tipo_cbte 
AND tf.compromete_factura in (1,-1) 
AND ci.id_producto = p.Id_Producto 
AND p.Id_Familia = pf.Id_Familia 
AND ci.Fecha_QA >= @pPeriodo_Desde	
AND ci.Fecha_Qa < @pPeriodo_Hasta + 1
AND f.id_estado_cbte in (1,2,4)  
AND f.Fecha >= @pFactura_Desde
AND f.Fecha < @pFactura_Hasta
GROUP BY pf.id_familia


SELECT P.Id_Familia,P.Descripcion
,CAST(@pPeriodo_Desde AS DATE) AS Desde
,CAST(@pPeriodo_Hasta AS DATE) AS Hasta
,ISNULL(F.Facturado,0) as Facturado
,CAST(@pFactura_Desde AS DATE) AS 'Fac. Desde'
,CAST(@pFactura_Hasta AS DATE) AS 'Fac. Hasta'
,ISNULL(C.cobrado,0) AS Cobrado
,CAST(@pRecibo_Desde AS DATE) AS 'Rec. Desde'
,CAST(@pRecibo_Hasta AS DATE) AS 'Rec. Hasta'
,ISNULL(F.Facturado,0) - ISNULL(C.cobrado,0) AS Diferencia
,CASE ISNULL(F.Facturado,0) WHEN 0 THEN 0
  ELSE (1 - (ISNULL(F.Facturado,0) - ISNULL(C.cobrado,0)) / ISNULL(F.Facturado,0)) * 100 
  END
   AS Porcentaje
FROM Prod_Familias P 
LEFT OUTER JOIN #TmpFacturado F  ON P.Id_Familia = F.Id_Familia
LEFT OUTER JOIN #TmpCobrado C  ON P.Id_Familia = C.Id_Familia
WHERE ISNULL(F.Facturado,0) + ISNULL(C.cobrado,0) <> 0
ORDER BY P.Descripcion


/*

 EXEC CPJ_Facturado_Cobrado '{"Periodo_Desde":"20170301","Periodo_Hasta":"20170331",
  "Recibo_Desde":"20170501","Recibo_Hasta":"20190430",

						}'

							  "Factura_Desde":"20100401","Factura_Hasta":"20170228",

							  "ModoDebug":"1"
							 
*/




